#include <windows>
#pragma option push -a1
#include <setupapi>
#pragma option pop
#include <assert>
#include <iostream>

using namespace std;

void displayError(const char* msg){
  cout << msg << endl;
  system("PAUSE");
  exit(0);
};
//---------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete [] x;
  x = NULL;
}
//---------------------------------------------------------
int searchInterfaceHidDevices()
{
    HMODULE hHidLib;
    HDEVINFO deviceInfoSet;
    SP_INTERFACE_DEVICE_DATA deviceInterfaceData;
    DWORD  memberIndex = 0;
    GUID classGuid;
    PSP_DEVICE_INTERFACE_DETAIL_DATA deviceInterfaceDetailData = NULL;
    DWORD requiredSize = 0;
    DWORD deviceInterfaceDetailDataSize = 0;
    DWORD searchMaxDevice = 100;
    bool done = false;

    void (__stdcall *HidD_GetHidGuid)(OUT LPGUID HidGuid);

    hHidLib = LoadLibrary("C:\\Windows\\system32\\HID.DLL");
    if (!hHidLib)
      displayError("Bd doczenia biblioteki HID.DLL.");

    (FARPROC&) HidD_GetHidGuid = GetProcAddress(hHidLib,
                                              "HidD_GetHidGuid");
    if (!HidD_GetHidGuid){
       FreeLibrary(hHidLib);
       displayError("Nie znaleziono identyfikatora GUID.");
    }

    HidD_GetHidGuid (&classGuid);

    deviceInfoSet = SetupDiGetClassDevs(&classGuid, NULL, NULL,
                                       (DIGCF_PRESENT | DIGCF_DEVICEINTERFACE));

    deviceInterfaceData.cbSize = sizeof(SP_INTERFACE_DEVICE_DATA);

    while(!done) {
       for(; memberIndex < searchMaxDevice; memberIndex++) {
          if(SetupDiEnumDeviceInterfaces(deviceInfoSet,0,&classGuid,
                                         memberIndex,&deviceInterfaceData)) {
            SetupDiGetDeviceInterfaceDetail(deviceInfoSet,&deviceInterfaceData,
                                         NULL,0,&deviceInterfaceDetailDataSize,
                                         NULL);
            requiredSize = deviceInterfaceDetailDataSize;
            deviceInterfaceDetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)\
                                new DWORD[deviceInterfaceDetailDataSize];

               if(deviceInterfaceDetailData) {
                  deviceInterfaceDetailData->cbSize=\
                               sizeof(SP_INTERFACE_DEVICE_DETAIL_DATA);
                }
                else {
                   SetupDiDestroyDeviceInfoList(deviceInfoSet);
                   releaseMemory(deviceInterfaceDetailData);
                   return 0;
                }
                if(!SetupDiGetDeviceInterfaceDetail(deviceInfoSet,
                           &deviceInterfaceData,deviceInterfaceDetailData,
                           requiredSize,&deviceInterfaceDetailDataSize,NULL)){
                   SetupDiDestroyDeviceInfoList(deviceInfoSet);
                   releaseMemory(deviceInterfaceDetailData);
                   return 0;
                }
            }
            else {
                if(ERROR_NO_MORE_ITEMS == GetLastError()){
                  done = TRUE;
                  break;
                }
            }
            cout << deviceInterfaceDetailData->DevicePath << endl;
            releaseMemory(deviceInterfaceDetailData);
        }
    }
    SetupDiDestroyDeviceInfoList(deviceInfoSet);
    FreeLibrary(hHidLib);
    return memberIndex;
}
//---------------------------------------------------------
int main(){
   cout << "\nLiczba interfejsw urzdze klasy HID w systemie = "\
        << searchInterfaceHidDevices() << endl;
   cout << endl;
   system("PAUSE");
   return 0;
}
//---------------------------------------------------------
 
